<?php

namespace App\Services\FirmPlans;

use App\Interfaces\FirmPlans\FirmPlanInterface;
use App\Models\Firm;
use App\Repositories\FirmRepository;
use Illuminate\Support\Facades\Auth;

class FirmPlanService
{
    public function __construct
    (
        protected  FirmPlanInterface $firmPlan,
        protected  FirmRepository $firmRepository
    ){}

    public function purchasePlan($request): string
    {
        $userId=Auth::id();
        $planId=$request->id;
        $firmId = $request->firm_id;

        $existing=$this->firmPlan->getFirmPlanById($firmId, $planId);

        $firm = Firm::whereHas('userFirms', function ($query) use ($userId) {
            $query->where('user_id', $userId)
                ->whereIn('status', [1, 2]);
        })
            ->where('id', $firmId)
            ->first();

        if (!$firm) {
            return  'Фирма не найдена';
        }

        $this->firmPlan->updateFirmPlan($firmId);
        if($existing)
        {
            if($firm->left_days>0){
                $status='active';
            }else{
                $status='not_paid';
            }
            $this->firmPlan->updateFirmPlanById($firmId,$planId,$status);
            return "Updated existing plan";
        }
        return $this->firmPlan->assignPlanToFirm($firmId,$planId);
    }
}
