<?php
namespace  App\Services\FirmServices;

use App\Interfaces\FirmCityInterface;
use Illuminate\Support\Facades\Cache;

class CityServices {
    public function __construct(
        protected  FirmCityInterface $firmCity
    ){}
    public function cities($request){
        $firmId=$request->header('firm_id');
        $cachedCities = Cache::get("firm_{$firmId}_cities");
        if (!$cachedCities){
            $cities=$this->firmCity->cities();
            Cache::put("firm_{$firmId}_cities",$cities->toArray(), now()->addHours(6));
            $cachedCities = Cache::get("firm_{$firmId}_cities");
            return $array=['cities'=>$cachedCities];
        }
       return $array=['cities'=>$cachedCities];
    }
    public  function  citychecked($request){
        $firmId=$request->header('firm_id');
        $cityId=request('id');
        $status =request()->boolean('status');
        $cities = Cache::get("firm_{$firmId}_cities");
        if (!$cities) {
            $cities = $this->cities($firmId);
        }
        $updated = $cities->map(function ($city) use ($cityId, $status) {
            if ($city->id == $cityId) {
                $city->checked = $status;
            }
            return $city;
        });
        Cache::put("firm_{$firmId}_cities", $updated->toArray(), now()->addHours(6));
        return $updated;
    }


}
