<?php

namespace App\Services;

use App\Interfaces\PaymentRepositoryInterface;
use App\Models\Payment;
use App\Models\PaymentImage;

class PaymentService
{
    public function __construct(
        protected PaymentRepositoryInterface $payment_repository
    ) {}
     /**
     * @OA\Get(
     *      path="/api/payment_info",
     *      tags={"Payment"},
     *       security={{"bearerAuth":{}}},
     *      
     *      @OA\Response(
     *          response=200,
     *          description="Successful operation",
     *          @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *      ),
     *  )
     */

    public function getPayments()
    {
        return $this->payment_repository->getPayments();
    }

    /**
     * @OA\Post(
     *     path="/api/get_payments_by_id",
     *     tags={"Payment"},
     *     security={{"bearerAuth":{}}},
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                 type="object",
     *                 @OA\Property(
     *                     property="id",
     *                     type="integer",
     *                     example=1
     *                 )
     *                
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Success",
     *          @OA\MediaType(
     *           mediaType="application/json",
     *          )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Unauthenticated",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="message", type="string", example="Unauthenticated")
     *         )
     *     )
     * )
     */

    public function getPaymentsByID($payments_request)
    {
        $id = $payments_request->id;
        return $this->payment_repository->getPaymentsByID($id);
    }
}
