<?php

namespace App\Services\Payments;

use Illuminate\Http\Client\Response;
use Illuminate\Support\Facades\Http;

class AlifPaymentService
{
    public function payments(object $payments): Response
    {
        return Http::post('alif',
            [
                "merchant" => config('services.payment.merchant'),
                "order_id" => $payments->id,
                "currency" => "TJS",
                "amount" => $payments->amount,
                "exp_time" => 40,
                "phone" => config('services.payment.phone'),
                "description" => "iCorp",
                "callback_url" => "https://acquiring.dc.tj/pay/new/callback.php",
                "sign" => md5(
                    config('services.payment.merchant')
                    . $payments->id
                    . config('services.payment.secret_key'))
            ]);
    }

}
