<?php

namespace App\Services\Payments;

use Illuminate\Http\Client\Response;
use Illuminate\Support\Facades\Http;

class DcPaymentService
{
    public function payments(object $payments): Response
    {

        return Http::post('https://invoice.dc.tj/v1/create',
            [
                "merchant" => config('services.paymentDc.merchant'),
                "order_id" => $payments->id,
                "currency" => "TJS",
                "amount" => $payments->amount,
                "exp_time" => config('services.payments.exp_time'),
                "phone" => config('services.payments.phone'),
                "description" => "iCorp",
                "callback_url" => config('services.paymentDc.callback_url'),
                "sign" => md5(
                    config('services.paymentDc.merchant')
                    . $payments->id
                    . config('services.paymentDc.secret_key'))
            ]);
    }

    public function check(string $payment_id, string $invoice_id): Response
    {
        return Http::post('https://invoice.dc.tj/v1/check', [
            "merchant" => config('services.paymentDc.merchant'),
            "order_id" => $payment_id,
            "invoice_id" => $invoice_id,
            "sign" => md5(
                config('services.paymentDc.merchant')
                . $payment_id
                . config('services.paymentDc.secret_key'))
        ]);

    }

}
