<?php

namespace App\Services\Plans;

use App\Interfaces\Plans\PlanInterface;
use App\Models\FirmPlan;
use App\Models\Plan;
use App\Repositories\Plans\PlanRepository;
use Illuminate\Support\Facades\Cache;

class PlanService
{
    public function __construct
    (
        protected  PlanInterface $plan
    ){}

    public function getPlans()
    {
        /**
         * @OA\Get(
         *      path="/api/get_plans",
         *      tags={"Firm"},
         *       security={{"bearerAuth":{}}},
         *      summary="Get tariff plans",
         *      @OA\Response(
         *          response=200,
         *          description="Successful operation",
         *          @OA\MediaType(
         *           mediaType="application/json",
         *      )
         *      ),
         *  )
         */
        return $this->plan->getPlans();
    }

}
