<?php

namespace App\Services\Search;

use App\Interfaces\OrderInterfaces\OrderInterface;
use Illuminate\Pagination\LengthAwarePaginator;

class ElasticsearchService
{
    public function __construct
    (
       protected OrderInterface $orderInterface
    ){}

    public function search(
        string $index,
        int    $from,
        int    $size,
        array  $filters,
        array  $should,
        array  $sort
    ): LengthAwarePaginator
    {

        $client = app('elasticsearch');


        $query = ['bool' => ['filter' => $filters]];

        if (!empty($should)) {
            $query['bool']['must'] = [];
            $query['bool']['should'] = $should;
            $query['bool']['minimum_should_match'] = 1;
        }

        $response = $client->search([
            'index' => $index,
            'body' => [
                'from' => $from,
                'size' => $size,
                'query' => $query,
                'sort' => $sort,
            ]
        ]);

        $items = collect($response['hits']['hits'])->pluck('_source')->values();
        $items = $items->map(function ($item) {

             $item['quantity'] = $this->orderInterface->getProductQuantityById($item['id'],$item['firm_id'])?? 0;

            return $item;
        });

        $total = $response['hits']['total']['value'];

        return new LengthAwarePaginator(
            $items,
            $total,
            $size,
            ($from / $size) + 1,
            ['path' => request()->url(), 'query' => request()->query()]
        );
    }
}

