<?php

namespace App\Services\Search;

use App\Interfaces\ProductTypeInterface;
use Illuminate\Support\Facades\Cache;

class ProductTypeService
{
    public function __construct(
        protected ProductTypeInterface $productType,
    )
    {}

    /**
     * @OA\Get(
     *      path="/api/search/gettype",
     *      tags={"Searches"},
     *       security={{"bearerAuth":{}}},
     *      summary="",
     *      description="",
     *     @OA\Parameter(
     *           name="firm_id",
     *           in="header",
     *           required=true,
     *           @OA\Schema(
     *               type="integer",
     *               example=1
     *           )
     *       ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful operation",
     *          @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *      ),
     *  )
     */
    public function getProductType($request)
    {
        $firmId=$request->header('firm_id');
        $product_name_types=$this->productType->getProductType();
        $cech=Cache::get("type_{$firmId}_");

        if (!$cech){
           Cache::put("type_{$firmId}_",$product_name_types,now()->addHours(1));
            $cech=Cache::get("type_{$firmId}_");
        }

        return $cech;
    }
    public function typeById($product_type_id): array
    {

        $typeById=$this->productType->typeById($product_type_id);
        $keywordsArray = [];

        foreach ($typeById as $type)
        {
            $decoded = json_decode($type['keywords'], true);
            if (is_array($decoded)) {
                $keywordsArray = array_merge($keywordsArray, $decoded);
            }
        }
        return $keywordsArray;
    }
}
