<?php

namespace App\Services\Search\QueryBuilder;

use Illuminate\Support\Collection;


class FilterBuilder
{
    public function build(array $params, Collection $overheadIds, array $productType): array
    {
        $filters = [];
        $productTypeQueries = [];

        if (!empty($productType)) {
            foreach ($productType as $kw) {

                $cleanKw = trim($kw);
                if (!empty($cleanKw)) {
                    $productTypeQueries[] = [
                        'match' => [
                            'title' => [
                                'query' => $kw,
                            ]
                        ]
                    ];
                }
            }
        }

        if (!empty($productTypeQueries)) {
            $filters[] = [
                'bool' => [
                    'should' => $productTypeQueries,
                    'minimum_should_match' => 1
                ]
            ];
        }

        if (!$overheadIds->isEmpty()) {
            $filters[] = [
                'terms' => ['overhead_id' => $overheadIds]
            ];
        } else {
            $filters[] = [
                'terms' => ['overhead_id' => [0]]
            ];
        }

        // discount
        if (!empty($params['discount'])) {
            $filters[] = [
                'range' => ['discounts' => ['gt' => 0]]
            ];
        }

        // price
        if (!empty($params['price_min']) || !empty($params['price_max'])) {
            $range = [];
            if (!empty($params['price_min'])) $range['gte'] = (float)$params['price_min'];
            if (!empty($params['price_max'])) $range['lte'] = (float)$params['price_max'];

            $filters[] = ['range' => ['price' => $range]];
        }

        return $filters;
    }

}
