<?php

namespace App\Services\Search\QueryBuilder;

class ShouldQueryBuilder
{
    public function build(array $words): array
    {
        $queries = [];
        $baseBoost = 5;

        foreach ($words as $word) {
            if (mb_strlen($word) < 2) continue;

            $isCyrillic = preg_match('/[а-яё]/iu', $word);

            $queries[] = [
                'match_bool_prefix' => [
                    'title' => [
                        'query' => $word,
                        'fuzziness' =>'AUTO',
                        'boost' => $isCyrillic ? $baseBoost + 2 : $baseBoost,
                    ]
                ]
            ];
        }
//        dd($queries);
        return $queries;
    }
}
