<?php

namespace App\Services\Search\QueryBuilder;

class SortBuilder
{
    public function build(?string $sort): array
    {
        return match ($sort) {
            'price_desc' => [['price' => 'desc']],
            'price_asc' => [['price' => 'asc']],
            'newest'    => [['rating' => 'desc']],
            default     => [['_score' => 'desc']],
        };
    }
}

