<?php

namespace App\Services\SearchServices;



use App\Interfaces\FilterMyPartnerInterface;
use App\Repositories\SearchRepositories\FilterMyPartnersRepository;
use http\Env\Request;
use Illuminate\Support\Facades\Cache;

class FilterMyPartnersService
{
    public function __construct(
       protected FilterMyPartnerInterface $myPartner
    )
    {}

    public  function  filterMyPartner($request): array
    {
        $firmId=$request->header('firm_id');
        $cech=Cache::get("firm_{$firmId}_partner");
        if($cech){
            $myFirm=$this->myPartner->filterMyPartners($firmId);
//            dd($myFirm);
            Cache::put("firm_{$firmId}_partner",$myFirm, now()->addHours(6));
            $cech = Cache::get("firm_{$firmId}_cities");
            return $array=[ 'myPartner'=>$cech];
        }

        return $array=['myPartner'=>$cech];
    }

    public  function partnerchecked( $request){
        $firmId=$request->header('firm_id');
        $Id=$request->input('id');
        $status =$request->boolean('status');
        $partners = Cache::get("firm_{$firmId}_partner");
        if (!$partners) {
            $partners = $this->filterMyPartner($firmId);
        }

        $updated = $partners->map(function ($partner) use ($Id, $status) {
            if ($partner->id == $Id) {
                $partner->checked = $status;
            }
            return $partner;
        });
        Cache::put("firm_{$firmId}_partner", $updated, now()->addHours(6));
        return $updated;
    }


}
