<?php

namespace App\Services;

use App\Http\Caches\SmsCache;
use App\Interfaces\VerificationServiceInterface;
use App\Repositories\AuthRepository;


class SmsVerificationService implements VerificationServiceInterface
{
    public function __construct(protected AuthRepository $authRepository, protected GenerateCodeService $generate_code,
        protected  SmsCache $smsCache
    ) {}
    public function createVerificationCode($phone)
    {
        $code = $this->generate_code->generateCode();
        $this->smsCache->smsput($phone, $code);
        $verify=$this->smsCache->smsget($phone);
        return [
            "message" => "Код отправлен по SMS",
            "code" => $verify
        ];
    }
    public function verificationCode($code, $phone)
    {
        $data=$this->smsCache->smsget($phone);
        if (!$data) {
            return [
                "message" => "неверный номер",
                "status" => false,
                "code" => 400
            ];
        }
        if ($data == $code) {
            return [
                "message" => "Success",
                "status"  => true,
                "code"    => 200
            ];
        }

        return [
            "message" => "неверный код",
            "status" => false,
            "code" => 400
        ];
    }
}
