<?php

namespace App\Services\Tutorials;

use App\Interfaces\Tutorials\TutorialInterface;

class TutorialService
{
    public function __construct
    (
       protected TutorialInterface $tutorial
    )
    {}
    /**
     * @OA\Get(
     *      path="/api/tutorials",
     *      tags={"Firm"},
     *       security={{"bearerAuth":{}}},
     *      summary="Get tutorials",
     *      @OA\Response(
     *          response=200,
     *          description="Successful operation",
     *          @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *      ),
     *  )
     */
    public function get()
    {
        return $this->tutorial->get();
    }
}
