<?php

namespace App\Services;

use App\Interfaces\UserInterface;
use App\Repositories\UserRepository;

class UserService implements UserInterface
{
    /**
     * @OA\Get(
     *      path="/api/getmyfirms",
     *      tags={"Firm"},
     *       security={{"bearerAuth":{}}},
     *      summary="Get my Firm",
     *      @OA\Response(
     *          response=200,
     *          description="Successful operation",
     *          @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *      ),
     *  )
     */


    public function __construct(protected UserRepository $user_repository)
    {
    }


    public function createUser($name, $phonenumber, $code)
    {
        $user = $this->user_repository->userGetByPhone($phonenumber);
        if (!$user) {
            $user = $this->user_repository->createUser($name, $phonenumber, $code);
            return $user;
        } else {
            $id = $user->id;
            $user = $this->user_repository->updatePassword($code, $id);
            return $user;
        }
    }

    /**
     * @OA\Post(
     *     path="/api/profile",
     *     tags={"User"},
     *     security={{"bearerAuth":{}}},
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                 type="object",
     *                 @OA\Property(
     *                     property="name",
     *                     type="string",
     *                     example="User"
     *                 ),
     *
     *                 @OA\Property(
     *                    property="img",
     *                    type="string",
     *                    format="binary",
     *                    example=null
     *                  )
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Success",
     *         @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Unauthenticated",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="message", type="string", example="Unauthenticated")
     *         )
     *     )
     * )
     */

    public function profile($request)
    {
        $name = $request->name;
        $img = $request->img ?? "/files/Users/user.png";
        $profile = $this->user_repository->profileUpdate($name, $img);
        return $profile;
    }
}
