<?php

namespace App\Traits;

use App\Models\OrderStatus;
use Illuminate\Database\Eloquent\Casts\Attribute;

trait HasOrderStatus
{
    public static function getStatuses(): array
    {
        return [
            OrderStatus::DRAFT->value => 'draft',
            OrderStatus::SENT->value => 'sent',
            OrderStatus::ACCEPTED->value => 'accepted',
            OrderStatus::PROCESSED->value => 'processed',
            OrderStatus::REJECTED->value => 'rejected',
            OrderStatus::COMPLETED->value => 'completed',
            OrderStatus::ARCHIVED->value => 'archived',
        ];
    }

    public function status(): Attribute
    {
        return Attribute::make(
            get: fn(int $value) => self::getStatuses()[$value] ?? 'unknown',
        );
    }
}
