<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Casts\Attribute;

trait HasStatus
{
    protected $statuses=[
        -1=>"deleted",
        0=>"inactive",
        1=>"active",
        2=>"pending"
    ];

    public function status() : Attribute
    {
        return Attribute::make(
            get: fn(string $value)=>$this->statuses[$value] ??"unknown",
        );
    }
}
