<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */
    'search' => [
        'hosts' => [
            env('ELASTICSEARCH_SCHEME', 'http') . '://' .
            env('ELASTICSEARCH_USERNAME') . ':' .
            env('ELASTICSEARCH_PASSWORD') . '@' .
            env('ELASTICSEARCH_HOST') . ':' .
            env('ELASTICSEARCH_PORT', 9200),
        ],
    ],


    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],
    'passport' => [
        'client_id' => env('CLIENT_ID'),
        'client_secret' => env('CLIENT_SECRET'),
    ],
    'paymentDc' => [
        'merchant' => env('MERCHANT'),
        'secret_key' => env('SECRET_KEY'),
        'callback_url'=>env('CALLBACK_URL')

    ],
    'payments' => [
        'phone' => env('PHONE'),
        'exp_time' => env('EXP_TIME'),
    ]


];
