<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('plans', function (Blueprint $table){
            $table->id();
            $table->string('name');
            $table->string('price_detail');
            $table->float('price');
            $table->enum('type',['month','days']);
            $table->string('description');
            $table->enum('status',['active','inactive'])->default('inactive');
            $table->datetimes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
       Schema::dropIfExists('plans');
    }
};
