<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('firm_plans', function(Blueprint $table){
            $table->id();
            $table->integer('firm_id');
            $table->foreignId('plan_id')->constrained('plans')->onDelete('cascade');
            $table->dateTime('exp_time')->nullable();
            $table->enum('status', ['active', 'inactive', 'not_paid'])->default('inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('firm_plans');
    }
};
