<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table){
           $table->id();
           $table->foreignId('firm_plan_id')->constrained('firm_plans')->onDelete('cascade');
           $table->float('amount');
           $table->enum('status',['paid','not_paid'])->default('not_paid');
           $table->datetimes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
