<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reviews', function (Blueprint $table){
            $table->id();
            $table->integer('supplier_id');
            $table->integer('firm_id');
            $table->foreignId('reason_list_id')->constrained('reason_lists')->onDelete('cascade');
            $table->string('product_name');
            $table->string('comment');
            $table->integer('status')->default(1);
            $table->datetimes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reviews');
    }
};
