<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PlansTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            ['name' => 'Базовый', 'price_detail' => '1 сомони / день', 'price'=>'1',  'type'=>'days', 'description' => 'Оплата только за активные дни.\\n Поиск, корзиназа активные дни.\\n Поиск, корзина, партнёры, сертификаты, бартеры, обсуждения и акции.'],
            ['name' => 'Премиум', 'price_detail' => '50 сомони / месяц', 'price'=>'50',  'type'=>'month', 'description' => 'Добавление товаров, AI-помощник, мультиязычность, заявки и чат с партнёрами.'],

        ];
        foreach ($plans as $plan) {
            DB::table('plans')->insert([
                'name' => $plan['name'],
                'price_detail' => $plan['price_detail'],
                'price'=>$plan['price'],
                'type'=>$plan['type'],
                'description' => $plan['description'],
                'status' =>'active',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
