<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ReasonListSeeder extends Seeder
{
    public function run(): void
    {
        $reason_lists = [
            [
                'name'=>'Товар соответствует описанию','type'=>'like'
            ],[
                'name'=>'Оригинальный товар','type'=>'like'
            ],[
                'name'=>'Товар соответствует описанию','type'=>'dislike'
            ],[
                'name'=>'Дубликат / неоригинал','type'=>'dislike'
            ],[
                'name'=>'Повреждённая упаковка','type'=>'dislike'
            ],[
                'name'=>'Не соответствует фото','type'=>'dislike'
            ],[
                'name'=>'Есть в списке, но отсутствует на складе','type'=>'dislike'
            ],[
                'name'=>'Товар снят с продажи','type'=>'dislike'
            ],[
                'name'=>'Неверная цена продажи','type'=>'dislike'
            ],[
                'name'=>'Нет сертификата соответствия','type'=>'dislike'
            ],[
                'name'=>'Повреждён при транспортировке','type'=>'dislike'
            ],
        ];
        foreach ($reason_lists as $reason_list){
            DB::table('reason_lists')->insert([
                'name'=>$reason_list['name'],
                'type'=>$reason_list['type'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
