<?php

use App\Http\Controllers\DrugstoreController;
use App\Http\Controllers\FirmPlanController;
use App\Http\Controllers\Nomenclatures\NomenclatureController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\PlanController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\TutorialController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\CountryController;
use App\Http\Controllers\ElasticsearchController;
use App\Http\Controllers\FirmController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PartnersController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\UserController;
use App\Http\Middleware\left_daysMiddleware;
use  App\Http\Controllers\SearchController;
use App\Http\Controllers\DashboardController;

Route::post('callback',[PaymentController::class, 'callbackDc']);

Route::get('/es-test', function () {
    $client = app('elasticsearch');
    try {
        $client1 = $client->info()->asArray();
    } catch (Exception $e) {
        $client1 = ['error' => $e->getMessage()];
    }
    return [
        'client' => $client1,
        'user' => env('ELASTICSEARCH_USERNAME'),
        'pass' => env('ELASTICSEARCH_PASSWORD'),
    ];
});

Route::controller(AuthController::class)->group(function () {
    Route::post('/phonenumber', 'sendCode');
    Route::post('/verifysms', 'verifysms');
});
Route::controller(CountryController::class)->group(function () {
    Route::get('/countryCodes', 'countryCode');
});

//city
Route::get('/getCities', [CityController::class, "getCities"]);


Route::middleware(['auth:api'])->group(function () {
    Route::get('/logout', [AuthController::class, 'logout']);
    Route::controller(FirmController::class)->group(function () {
        Route::get('firm_categories', 'firmCategories');
        Route::post('/createfirm', 'createFirm');
        Route::get('/getmyfirms', 'getMyFirms');
        Route::get('/day_plus', 'day_plus');
    });

    //paymens
    Route::controller(PaymentController::class)->group(function () {
        Route::get('/payment_info', 'getAllPay');
        Route::post('new_payments','newPayments');
    });

    Route::get('/dashboard/{firmId}', [DashboardController::class, 'dashboard']);
    Route::get('help_desk', [HomeController::class, 'HelpDesk']);
    Route::post('request_call', [HomeController::class, 'Requestcall']);
    Route::controller(UserController::class)->group(function () {
//        Route::post('/profile', 'profile');
    });

//    tariff plans
    Route::get('get_plans', [PlanController::class, 'getPlans']);

//    firm plan
    Route::post('purchase_firm_plan', [FirmPlanController::class, 'purchasePlan']);

//    tutorials
    Route::get('tutorials', [TutorialController::class, 'getTutorials']);

//   Notifications
    Route::get('get_notifications', [NotificationController::class, 'getNotifications']);

    //Elastic
    Route::prefix('elastic')->controller(ElasticsearchController::class)->group(function () {
        Route::get('show', 'show');
        Route::get('createindex', 'createIndex');
        Route::get('synced', 'synced');
        Route::get('delete', 'delete');
    });


    Route::middleware(left_daysMiddleware::class)->group(callback: function () {
        Route::prefix('firm')->controller(FirmController::class)->group(function () {
            Route::get('firm_profile', 'firmProfile');
            Route::get('working_data', 'workingData');
            Route::post('update_working_data', 'updateWorkingData');
            Route::post('update_geo', 'updateGeo');
        });

        // search
        Route::prefix('search')->controller(SearchController::class)->group(callback: function () {
            Route::post('/search', 'search');
            Route::get('/gettype', 'getProductType');
        });
        Route::post('product_by_id', [DrugstoreController::class, 'getProductById']);
        // city
        Route::get('/city/by_checked', [CityController::class, "citiesByChecked"]);
        Route::post('/city/update_checked', [CityController::class, 'updateChecked']);


        Route::prefix('orders')->controller(OrderController::class)->group(function () {
            Route::post('/addtoorder', 'addToOrder');
            Route::post('/orders', 'orders');
            Route::post('/update_quantity', 'updateQuantity');
            Route::post('/delete_product_for_order_item', 'deleteProductForOrderItem');
            Route::post('/delete', 'deleteOrder');
            Route::get('/status', 'getStatusOrder');
            Route::post('/details', 'getOrderItems');
            Route::post('/get_product_by_oderitem_id', 'getProductByOderItemId');
            Route::get('/order_lists', 'orderLists');
            Route::post('/send_order', 'SendOrder');
        });

        Route::prefix('partner')->controller(PartnersController::class)->group(function () {
            Route::post('/my', 'myPartners');
            Route::post('/info', 'partnerInfo');
            Route::post('/update_checked', 'updateChecked');
            Route::post('/statistic', 'statistic');
            Route::get('/count_checked', 'countChecked');
            Route::post('details', 'getPartnerDetails');
        });

        Route::prefix('reviews')->controller(ReviewController::class)->group(function () {
            Route::post('create', 'create');
            Route::post('reviews', 'getReviews');
            Route::get('reason_list', 'reasonList');
        });

        Route::prefix('nomenclatures')->controller(NomenclatureController::class)->group(function () {
            Route::post('/get_nomenclatures_by_search', 'get_nomenclatures_by_search');
            Route::post('/get_details_by_id', 'get_details_by_id');
            Route::post('/get_analogues', 'get_analogues');
        });
    });
});
